
DROP VIEW public. v_envia_produtos_fiscoreducaoz;

CREATE OR REPLACE VIEW public. v_envia_produtos_fiscoreducaoz AS 

SELECT g.cd_emp,
       g.cd_filial,
       g.cd_cx,
       CASE
           WHEN g.tptotalizadorisento::text = ''::CHARACTER varying::text THEN (g.tptotalizador::text || g.percimposto::text)::CHARACTER varying
           WHEN g.tptotalizador::text = 'S'::CHARACTER varying::text THEN ((g.tptotalizadorisento::text || g.tptotalizador::text) || '1'::text)::CHARACTER varying
           ELSE (g.tptotalizadorisento::text || '1'::text)::CHARACTER varying
       END AS totalizador,
       g.ds_prod,
       g.cd_prod,
       g.codigo_produto,
       sum(g.qt_it) AS qt_it,
       g.unidade,
       round(sum(g.vlr_it), 4) AS vlr_it,
       g.dt_vd,
       g.tp_prod,
       round(sum(g.vlr_tot_liq_it), 4) AS vlr_tot_liq_it,
       round(sum(g.vlr_tot_liq_it_cancel), 4) AS vlr_tot_liq_it_cancel,
       round(sum(g.vlr_desc_it), 4) AS vlr_desc_it,
       g.nr_cest,
       g.ncm_prod
FROM
  (SELECT a.cd_emp,
          a.cd_filial,
          a.cd_cx,
          b.cd_trib_fc,
          d.ds_prod,
          b.cd_prod,
          COALESCE(
                     (SELECT e.cd_barra
                      FROM est_prod_cd_barra e
                      WHERE b.cd_prod = e.cd_prod
                      LIMIT 1), '0000000000000'::CHARACTER varying) AS codigo_produto,
          sum(b.qt_it) AS qt_it,
          COALESCE(f.ds_un, 'UN'::CHARACTER varying, f.ds_un) AS unidade,
          round(sum(b.vlr_it) / count(b.vlr_it)::numeric, 4) AS vlr_it,
          round(sum(b.vlr_desc_it), 4) AS vlr_desc_it,
          a.dt_vd,
          h.tp_prod,
          CASE b.st_it
              WHEN 1 THEN round(sum(b.vlr_it * b.qt_it - b.vlr_desc_it), 4)
              ELSE 0::numeric
          END AS vlr_tot_liq_it,
          CASE b.st_it
              WHEN 2 THEN round(sum(b.vlr_it * b.qt_it - b.vlr_desc_it), 4)
              ELSE 0::numeric
          END AS vlr_tot_liq_it_cancel,
          d.nr_cest,
          d.ncm_prod,
          ltrim(replace(to_char(b.tx_icms_it, '09.99'::text), '.'::text, ''::text))::CHARACTER varying AS percimposto,
          CASE
              WHEN h.tp_prod = 10::numeric THEN 'S'::text
              ELSE 'T'::text
          END::CHARACTER varying AS tptotalizador,
          CASE
              WHEN b.cd_trib_fc::text = '040'::text
                   OR btrim(b.cd_trib_fc::text) = '050'::text THEN 'I'::CHARACTER varying
              WHEN btrim(b.cd_trib_fc::text) = '041'::text THEN 'N'::CHARACTER varying
              WHEN btrim(b.cd_trib_fc::text) = '060'::text
                   OR btrim(b.cd_trib_fc::text) = '010'::text THEN 'F'::CHARACTER varying
              ELSE ''::CHARACTER varying
          END AS tptotalizadorisento
   FROM pdv_vd a
   JOIN pdv_vd_it b ON a.cd_emp = b.cd_emp
   AND a.cd_filial = b.cd_filial
   AND a.cd_vd = b.cd_vd
   JOIN est_prod d ON b.cd_emp = d.cd_emp
   AND b.cd_prod = d.cd_prod
   LEFT JOIN est_prod_un_med f ON d.cd_un_vd = f.cd_ctr_un
   LEFT JOIN est_prod_cpl h ON b.cd_emp = h.cd_emp
   AND b.cd_filial = h.cd_filial
   AND b.cd_prod = h.cd_prod
   GROUP BY b.cd_trib_fc,
            d.ds_prod,
            b.cd_prod,
            f.ds_un,
            a.dt_vd,
            a.cd_emp,
            a.cd_filial,
            a.cd_cx,
            h.tp_prod,
            b.st_it,
            d.nr_cest,
            d.ncm_prod,
            b.tx_icms_it
   ORDER BY d.ds_prod) g
GROUP BY g.tptotalizador,
         g.tptotalizadorisento,
         g.ds_prod,
         g.cd_prod,
         g.codigo_produto,
         g.unidade,
         g.dt_vd,
         g.cd_emp,
         g.cd_filial,
         g.cd_cx,
         g.tp_prod,
         g.nr_cest,
         g.ncm_prod,
         g.percimposto;

